/** @file   minigunai.h
 * @brief   Declarations of MinigunAI - class.
 * @version $Revision: 1.1.1.1 $
 * @date    $Date: 2006/01/21 23:02:42 $
 * @author  Tomi Lamminsaari
 */
 
#ifndef H_WWW_MINIGUNAI_H
#define H_WWW_MINIGUNAI_H

#include "aicontroller.h"

namespace WeWantWar {


/** 
 * @par Behaviour of Minigun Alien
 * Minigun aliens just stay put and shoot player when he comes in sight.
 *
 * @brief       The logic that controls the Minigun Alien.
 * @author      Tomi Lamminsaari
 */
class MinigunAI : public AIController
{
public:
  ///
  /// Static members
  /// ==============

  
  
  ///
  /// Constructor, destructor
  /// =======================
  
  /** Constructor.
   * @param     pAlien            Pointer to alien we're controlling
   */
  MinigunAI( GameObject* pAlien );
  
  /** Destructor.
   */
  virtual ~MinigunAI();
  
  
  
  ///
  /// Methods
  /// =======
  
  /** Updates the controlling commands
   * @param     seeTarget         Indicates if we're seing our target.
   * @param     dist              Direct distance from our target.
   */
  virtual void updateAI( bool seeTarget, float dist );
  
  
protected:
  
  ///
  /// Members
  /// =======
  
  /** Tells if we're in alerted mode. */
  bool      m_alerted;
  
  /** THe previous player position is stored here. */
  eng2d::Vec2D  m_lastKnownPos;
};

};  // end of namespace

#endif // MINIGUNAI_H

/**
 * Version history
 * ===============
 * $Log: minigunai.h,v $
 * Revision 1.1.1.1  2006/01/21 23:02:42  lamminsa
 * no message
 *
 * Revision 1.0  2005-11-06 01:17:05+02  lamminsa
 * Initial revision
 *
 */
 
